<?php
include_once 'inc/navigation.php';
?>

   <main>

      <!-- breadcrumb-area-start -->
      <div class="it-breadcrumb-area it-breadcrumb-bg" data-background="images/students_graduation.webp">
         <div class="container">
            <div class="row ">
               <div class="col-md-12">
                  <div class="it-breadcrumb-content z-index-3 text-center">
                     <div class="it-breadcrumb-title-box">
                        <h3 class="it-breadcrumb-title">blog</h3>
                     </div>
                     <div class="it-breadcrumb-list-wrap">
                        <div class="it-breadcrumb-list">
                           <span><a href="/">home</a></span>
                           <span class="dvdr">//</span>
                           <span>blog</span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- breadcrumb-area-end -->

      <!-- blog-area-start -->
      <div class="it-blog-area  pt-120 pb-90">
         <div class="container">
            <?php
            $blogsPerPage = 6;
            $currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
            if ($currentPage < 1) $currentPage = 1;

            try {
                // Get total count of blogs
                $countSql = "SELECT COUNT(*) as total FROM blog WHERE publish_status = '1'";
                $countStmt = $pdo->prepare($countSql);
                $countStmt->execute();
                $totalBlogs = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
                
                // Calculate total pages
                $totalPages = ceil($totalBlogs / $blogsPerPage);
                if ($currentPage > $totalPages && $totalPages > 0) {
                    $currentPage = $totalPages;
                }
                
                // Calculate offset
                $offset = ($currentPage - 1) * $blogsPerPage;
                
                // Fetch blogs for current page
                $sql = "SELECT * FROM blog WHERE publish_status = '1' ORDER BY date DESC LIMIT :limit OFFSET :offset";
                $stmt = $pdo->prepare($sql);
                $stmt->bindValue(':limit', $blogsPerPage, PDO::PARAM_INT);
                $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
                $stmt->execute();
                $blogItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
                
            } catch(PDOException $e) {
                die("Database error: " . $e->getMessage());
            }
            ?>

            <div class="row">
                <?php
                if (!empty($blogItems)) {
                    foreach($blogItems as $blog) {
                        // Get first image from comma-separated list
                        $images = !empty($blog['blog_image']) ? explode(',', $blog['blog_image']) : [];
                        $firstImage = !empty($images[0]) ? 'blog_images/' . trim($images[0]) : 'assets/img/blog/blog-1-1.jpg';
                        
                        // Format date
                        $blogDate = !empty($blog['date']) ? strtotime($blog['date']) : time();
                        $formattedDate = date('d F Y', $blogDate);
                        
                        // Get comment count (you need to implement this based on your comment system)
                        $commentCount = 0; // Placeholder - implement your own comment counting
                        
                        // Truncate title
                        $title = htmlspecialchars($blog['blog_title']);
                        $truncatedTitle = strlen($title) > 80 ? substr($title, 0, 77) . '...' : $title;
                        ?>
                        
                        <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                            <div class="it-blog-item-box" data-background="assets/img/blog/bg-1.jpg">                  
                                <div class="it-blog-item">
                                    <div class="it-blog-thumb fix">
                                        <a href="blog-details.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>">
                                            <img src="<?php echo htmlspecialchars($firstImage); ?>" alt="<?php echo htmlspecialchars($blog['blog_title']); ?>" loading="lazy">
                                        </a>
                                    </div>
                                    <div class="it-blog-meta pb-15">
                                        <span>
                                            <i class="fa-solid fa-calendar-days"></i>
                                            <?php echo $formattedDate; ?>
                                        </span>
                                        <span>
                                            <i class="fa-light fa-messages"></i>
                                            Comment (<?php echo $commentCount; ?>)
                                        </span>
                                    </div>
                                    <h4 class="it-blog-title">
                                        <a href="blog-details.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>">
                                            <?php echo $truncatedTitle; ?>
                                        </a>
                                    </h4>
                                    <a class="it-btn sm" href="blog-details.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>">
                                        <span>
                                            read more
                                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </span>
                                    </a>   
                                </div>
                            </div>
                        </div>
                        
                        <?php
                    }
                } else {
                    ?>
                    <div class="col-12 text-center py-5">
                        <div class="alert alert-info">
                            <i class="fa-solid fa-newspaper fa-2x mb-3"></i>
                            <h4>No Blog Posts Available</h4>
                            <p>Check back soon for new blog posts!</p>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>

            <!-- Pagination -->
            <?php if ($totalPages > 1): ?>
            <nav aria-label="Blog pagination" class="mt-50">
                <ul class="pagination justify-content-center">
                    <!-- Previous Button -->
                    <li class="page-item <?php echo ($currentPage <= 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $currentPage - 1; ?>" aria-label="Previous">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                    
                    <!-- First Page -->
                    <?php if ($currentPage > 3): ?>
                    <li class="page-item">
                        <a class="page-link" href="?page=1">1</a>
                    </li>
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                    <?php endif; ?>
                    
                    <!-- Page Numbers -->
                    <?php 
                    $startPage = max(1, $currentPage - 2);
                    $endPage = min($totalPages, $currentPage + 2);
                    
                    for ($i = $startPage; $i <= $endPage; $i++): 
                    ?>
                        <li class="page-item <?php echo ($i == $currentPage) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>">
                                <?php echo $i; ?>
                                <?php if ($i == $currentPage): ?>
                                    <span class="sr-only">(current)</span>
                                <?php endif; ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <!-- Last Page -->
                    <?php if ($currentPage < $totalPages - 2): ?>
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                    <li class="page-item">
                        <a class="page-link" href="?page=<?php echo $totalPages; ?>"><?php echo $totalPages; ?></a>
                    </li>
                    <?php endif; ?>
                    
                    <!-- Next Button -->
                    <li class="page-item <?php echo ($currentPage >= $totalPages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $currentPage + 1; ?>" aria-label="Next">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                </ul>
                
                <!-- Page Info -->
                <div class="text-center mt-3 text-muted">
                    <small>
                        Showing <?php echo min($blogsPerPage, count($blogItems)); ?> of <?php echo $totalBlogs; ?> blog posts
                        (Page <?php echo $currentPage; ?> of <?php echo $totalPages; ?>)
                    </small>
                </div>
            </nav>

            <style>
            .pagination {
                margin-bottom: 0;
            }

            .page-link {
                color: #7A1E2B;
                border: 1px solid #ddd;
                padding: 8px 15px;
                margin: 0 3px;
                border-radius: 4px;
                transition: all 0.3s ease;
            }

            .page-link:hover {
                background-color: #7A1E2B;
                color: white;
                border-color: #7A1E2B;
            }

            .page-item.active .page-link {
                background-color: #7A1E2B;
                border-color: #7A1E2B;
                color: white;
            }

            .page-item.disabled .page-link {
                color: #6c757d;
                pointer-events: none;
                background-color: #fff;
                border-color: #ddd;
            }

            .page-item:first-child .page-link {
                border-top-left-radius: 4px;
                border-bottom-left-radius: 4px;
            }

            .page-item:last-child .page-link {
                border-top-right-radius: 4px;
                border-bottom-right-radius: 4px;
            }
            </style>
            <?php endif; ?>


         </div>
      </div>
      <!-- blog-area-end -->
<?php
include_once 'inc/footer.php';
?>